(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3737,        138]*)
(*NotebookOutlinePosition[      4374,        160]*)
(*  CellTagsIndexPosition[      4330,        156]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Example 4.13", "Subtitle"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[{1250 \( v'\)[t] \[Equal] 40000 - v[t]\^2, v[0] \[Equal] 0}, 
      v[t], t]\)], "Input"],

Cell[BoxData[
    \(Solve::"ifun" \(\(:\)\(\ \)\) 
      "Inverse functions are being used by \!\(Solve\), so some solutions may \
not be found."\)], "Message"],

Cell[BoxData[
    \({{v[
            t] \[Rule] \(200\ \((\(-1\) + \[ExponentialE]\^\(\(8\ t\)/25\))\)\
\)\/\(1 + \[ExponentialE]\^\(\(8\ t\)/25\)\)}}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(v[t_] = v[t] /. First[%]\)], "Input"],

Cell[BoxData[
    \(\(200\ \((\(-1\) + \[ExponentialE]\^\(\(8\ t\)/25\))\)\)\/\(1 + \
\[ExponentialE]\^\(\(8\ t\)/25\)\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Limit[v[t], t \[Rule] \[Infinity]]\)], "Input"],

Cell[BoxData[
    \(200\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[v[t] \[Equal]  .90*200, t]\)], "Input"],

Cell[BoxData[
    \(Solve::"ifun" \(\(:\)\(\ \)\) 
      "Inverse functions are being used by \!\(Solve\), so some solutions may \
not be found."\)], "Message"],

Cell[BoxData[
    \({{t \[Rule] 9.201371809895125`}}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      StyleBox[
        RowBox[{"t", 
          StyleBox["\[Infinity]",
            FontSize->10]}]], 
      StyleBox["=",
        FontVariations->{"CompatibilityType"->0}], 
      StyleBox["9.2",
        FontVariations->{"CompatibilityType"->0}]}]], "Input"],

Cell[BoxData[
    \(9.2`\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"height", "=", 
      RowBox[{
        SubsuperscriptBox["\[Integral]", "0", 
          StyleBox[
            RowBox[{"t", 
              StyleBox["\[Infinity]",
                FontSize->10]}]]], \(v[t] \[DifferentialD]t\)}]}]], "Input"],

Cell[BoxData[
    \(1037.7100842040245`\)], "Output"]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
WindowSize->{556, 622},
WindowMargins->{{28, Automatic}, {38, Automatic}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 32, 0, 65, "Subtitle"],

Cell[CellGroupData[{
Cell[1833, 57, 116, 2, 31, "Input"],
Cell[1952, 61, 160, 3, 35, "Message"],
Cell[2115, 66, 164, 3, 45, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[2316, 74, 57, 1, 24, "Input"],
Cell[2376, 77, 134, 2, 45, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[2547, 84, 67, 1, 24, "Input"],
Cell[2617, 87, 37, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[2691, 93, 65, 1, 24, "Input"],
Cell[2759, 96, 160, 3, 35, "Message"],
Cell[2922, 101, 66, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[3025, 107, 286, 9, 24, "Input"],
Cell[3314, 118, 38, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[3389, 124, 264, 7, 39, "Input"],
Cell[3656, 133, 53, 1, 27, "Output"]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

